//Note: Details of scilab software version and OS version used:
//Tested on OS: Windows 7 SP1, 64 bit and Windows XP SP3, 32 bit
//Scilab version: 5.4.1 (Tested on both 32 bit and 64 bit versions)
//Program Title: Study and generate Offset QPSK (OQPSK) waveforms

clear;
clc;
close;
T=2;// One symbol period
t = 0:0.01:T/2;//Sampling Matrix for half symbol period
f=1; // Carrier frequency (cycles per bit period)
//I=[0 0 1 1 0 0 1 1]; //data stream
I=[0 0 0 1 1 0 1 1]; //data stream giving dibit equivalent to 0,1,2,3
//I=[1 1 0 0 0 1 1 1]; //data stream

//Polar NRZ Converter
I_PNRZ = [] //empty matrix for Polar NRZ data
       for n = 1:length(I)
           if I(n)== 0 then
               I_PNRZ = [I_PNRZ, -1]
           else
               I_PNRZ = [I_PNRZ, 1]
           end
       end

I_Carrier = sqrt(2/T)*cos(2*%pi*f*t); //In phase carrier
Q_Carrier = sqrt(2/T)*sin(2*%pi*f*t); //Quadrature phase carrier

//Generation of OQPSK Waveform
z=0;//Starting point of plot on x-axis
    subplot(3,1,1) //I-PSK Plot
        a=gca();
        a.data_bounds=[0,-1.5;length(I_PNRZ),1.5]; 
        a.x_location="origin";
        a.grid=[1,1];
        title('I-Data and I-PSK')
            plot((t+z),I_Carrier*I_PNRZ(1));//I_Carrier * First bit (I Balance Modulator)
            plot((t+z),I_PNRZ(1),'r');//First bit Data for reference
//xpause(2000000);//Delay for observation
z=z+1;//Move starting point of plot on x-axis by 1 bit (half symbol) period
for n=2:1:length(I_PNRZ)
    if modulo(n,2)==0 then//Check for odd-even bit
        I_Bit=I_PNRZ(n-1)//set I bit as previous bit
        Q_Bit=I_PNRZ(n)//set Q bit as current bit
    else
        I_Bit=I_PNRZ(n)//set I bit as current bit
        Q_Bit=I_PNRZ(n-1)//set Q bit as previous bit
    end
    
    subplot(3,1,1) //I-PSK Plot
        a=gca();
        a.data_bounds=[0,-1.5;length(I_PNRZ),1.5]; 
        a.x_location="origin";
        a.grid=[1,1];
        title('I-Data and I-PSK')
            plot((t+z),I_Carrier*I_Bit);//I_Carrier * Even bit (I Balance Modulator)
            plot((t+z),I_Bit,'r');//I Data for reference
            
    subplot(3,1,2) //Q-PSK Plot
        a=gca();
        a.data_bounds=[0,-1.5;length(I_PNRZ),1.5]; 
        a.x_location="origin";
        a.grid=[1,1];
        title('Q-Data and Q-PSK')
            plot((t+z),Q_Carrier*Q_Bit);//Q_Carrier * Odd bit (Q Balance Modulator)
            plot((t+z),Q_Bit,'r');//Q Data for reference

    subplot(3,1,3) //QPSK Plot
        a=gca();
        a.data_bounds=[0,-1.5;length(I_PNRZ),1.5]; 
        a.x_location="Origin";
        a.grid=[1,1];
        title('OQPSK and I-Carrier')
            plot((t+z),(I_Carrier*I_Bit)+(Q_Carrier*Q_Bit));//I-PSK + Q-PSK (Adder)
            plot((t+z),I_Carrier,'r');//I Carrier for reference
z=z+1;//Move starting point of plot on x-axis by 1 bit (half symbol) period
//xpause(2000000);//Delay for observation
end
